#include <iostream>
#include <vector>
#include <stack>
#include <set>
#include <algorithm>

using namespace std;

vector<vector<int>> graph;
vector<int> visited;
vector<int> path;

void dfs(int node) {
    visited[node] = 1;
    path.push_back(node);
    for (int neighbor : graph[node]) {
        if (!visited[neighbor]) {
            dfs(neighbor);
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;

    if (n < 3) {
        cout << "-1\n";
        return 0;
    }

    graph.resize(n + 1);

    // Dodajemo osnovni trougao (1, 2, 3)
    graph[1].push_back(2);
    graph[2].push_back(1);
    graph[1].push_back(3);
    graph[3].push_back(1);
    graph[2].push_back(3);
    graph[3].push_back(2);

    // Ucitavanje i povezivanje novih prodavnica
    for (int i = 4; i <= n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i].push_back(a);
        graph[a].push_back(i);
        graph[i].push_back(b);
        graph[b].push_back(i);
        graph[i].push_back(c);
        graph[c].push_back(i);
    }

    visited.resize(n + 1, 0);

    // DFS za obilazak grafa
    dfs(1);

    if (path.size() != n + 1) {
        cout << "-1\n";
    } else {
        for (int node : path) {
            cout << node << " ";
        }
        cout << "\n";
    }

    return 0;
}